/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import java.applet.Applet;
import java.applet.AudioClip;
import java.net.URL;
import java.util.HashMap;

public class SoundProxy
extends HashMap {
    private static SoundProxy cSingeltonInstanz;
    protected static final String DEFAULT_BASE_URL_STRING = "/DE/siemens/ad/logo/sounds/";

    private SoundProxy() {
        super(5);
    }

    public static SoundProxy createInstance(String baseUrl) {
        cSingeltonInstanz = new SoundProxy();
        return cSingeltonInstanz;
    }

    public static SoundProxy getInstance() {
        if (cSingeltonInstanz == null) {
            SoundProxy.createInstance(null);
        }
        return cSingeltonInstanz;
    }

    public AudioClip getClip(String relativeURL) {
        AudioClip result = (AudioClip)this.get(relativeURL);
        if (result == null) {
            result = this.loadClip(relativeURL);
        }
        return result;
    }

    public void putClip(AudioClip clip, String relativeURL) {
        this.put(relativeURL, clip);
    }

    private AudioClip loadClip(String relativeURL) {
        AudioClip audioClip = null;
        URL clipUrl = this.getClass().getResource(DEFAULT_BASE_URL_STRING + relativeURL);
        try {
            audioClip = Applet.newAudioClip(clipUrl);
            this.putClip(audioClip, relativeURL);
        }
        catch (RuntimeException e) {
            System.out.println("Sound not found: " + clipUrl);
            audioClip = new AudioClip(){

                public void play() {
                }

                public void loop() {
                }

                public void stop() {
                }
            };
        }
        return audioClip;
    }
}

